/**
 * @fileoverview address bar actions
 * @author sunnyjiang
 * @version 1.1
 */

/**
 * @namespace address bar
 */
var addressbar = {};

addressbar._isAddressbarActive = false; // 地址栏下拉需要的相关状态

addressbar._isAddressinputFocus = false; // 是否激活的状态

addressbar._selectionStart = 0;
addressbar._selectionEnd = 0;

addressbar._lastSelectedText = '';
addressbar._lastSelectedText = ''; // 上一次选中的内容

addressbar.timer = null;

addressbar._inputStatus = {search: false, text: '', url: '', lastInput: '', firstUrl: '', enter: false, needSetAddress: true};

addressbar._cleared = false;	//是否已经清理选中状态了。C++判断到皮肤失去焦点时，会通过CallBack回调到ClearSelectInfo;由于时序问题，可能addressinput的blur会在这之后调到，这次blur不应该改变选中状态

//added by yinzhou
//地址栏下拉提示页面只需获取一次，保存住，提高效率
var addressListPage = null;
addressbar.getAddressListPage = function() {
	if (addressListPage != null) {
		return addressListPage;
	}

	try	{
		var pageList = qqbrowser.extension.getPages(qqbrowser.window.currentId(), ["addressbar"]);
		addressListPage = pageList[0];
	} catch (e)	{
	}

	return addressListPage;
};

/**
 * 初始化地址栏并响应键盘输入
 */
addressbar.init = function() {

	// added by yinzhou
 	// 初始化作短暂延时后拿到地址栏下拉页面提高效率
	setTimeout("addressbar.getAddressListPage()", 300);

	var addressInput = $('#address-input');

	// 焦点恢复到地址栏时，选择全部文字
/*	addressInput.bind('focus', function() {
		addressbar._isAddressinputFocus = true;

		addressbar._lastSelectedText = window.getSelection().toString(); // 为菜单选择文字删除功能提供支持
		debugger;
		console.log(addressbar._selectionStart + "---" + addressbar._selectionEnd);

		if(addressbar._selectionStart != addressbar._selectionEnd) {
			addressInput.get(0).setSelectionRange(addressbar._selectionStart, addressbar._selectionEnd);　
		} else {
			addressbar.selectAllInput();
		}

		addressInput.one('mouseup', function() {
			return false;
		});
	});*/
	addressInput.bind('focus', function() {
		addressbar._cleared = false;
		addressbar._isAddressinputFocus = true;
		addressbar._lastSelectedText = window.getSelection().toString(); // 为菜单选择文字删除功能提供支持
//		console.log(addressbar._selectionStart + "---" + addressbar._selectionEnd);
		addressInput.get(0).setSelectionRange(addressbar._selectionStart, addressbar._selectionEnd);
		addressInput.one('mouseup', function() {
			return false;
		});
	});
	
/*	addressInput.bind('click', function() {
		addressInput.css('text-align', 'left');
		
	});*/

	addressInput.bind('keyup', function() {

		var enter = addressbar._inputStatus.enter;
		addressbar._inputStatus.enter = false;
		
		if(($.trim(addressInput.val())) != '') { // 输入不为空时

			url = addressInput.val();
			addressbar.hideTextPlaceholder();
			
			// 上下键，改变default事件
			if(event.keyCode == 38 || event.keyCode == 40) {
				return false;
			}

			// 左右键不处理
			if(event.keyCode == 37 || event.keyCode == 39) { 
				return;
			}

			var search = addressbar._inputStatus.search;
			addressbar._inputStatus.search = false;

			// ESC键不处理
			if(event.keyCode == 27) {
				return;
			}

			var text = url.replace(window.getSelection(), ''); // 这是真正输入的文本，url有可能是补全的结果
			var randomId = utils.randomInt(4); // 四位随机数，将被地址栏下拉菜单传回来进行比对

			// backspace&delete键，删除一个字符，并且调用inputchange
			if(event.keyCode == 8 || event.keyCode == 46) {
				if(text.length != url.length) { // 当没有选中任何文字时删除，不改变输入框内容
					addressInput.val(text);
				}
				
				randomId = 10000; // 传递给下层，下层返回结果时根据此不自动补全
			}

			// added by yinzhou
			// ctrl + enter组合键补全网址并直接打开
			if (event.ctrlKey && event.keyCode == 13) {
				var url = "http://www." + $.trim(text) + ".com";
				addressInput.val(url);
				addressbar._inputStatus.lastInput = url;
				addressbar.openUrl(url);
				return;
			}

			if(event.altKey && event.keyCode == 13) { // alt + enter，新窗口打开
				// 如果匹配结果第一项存在且涵盖当前的url，根据第一项结果导航
				if(addressbar._inputStatus.firstUrl != '' && addressbar._inputStatus.firstUrl.indexOf(url) > -1) {
					addressbar.openUrl(addressbar._inputStatus.firstUrl, 0);
				} else {
					addressbar.openUrl(url, 0);
				}
				
				return;
			}

			if(event.shiftKey && event.keyCode == 13) { // shift + enter，搜索关键词
				addressbar.openUrl(text, 1, 1); // 1标识强制搜索
				return;
			}			

			if(event.keyCode == 13 && enter) { // 必须在地址栏一次完整的Enter down-up事件才导航
				// 如果search标志为真，调用搜索接口
				if(search) {
					addressbar.openUrl(url, 1, 1); // 1标识进行搜索
				}
				// 如果匹配结果第一项存在且涵盖当前的url，根据第一项结果导航
				else if(addressbar._inputStatus.firstUrl != '' && addressbar._inputStatus.firstUrl.indexOf(url) > -1) {
					addressbar.openUrl(addressbar._inputStatus.firstUrl);
				} 
				// 打开网址
				else {
					addressbar.openUrl();
				}
				return;
			}

			// 输入没发生变化时无需匹配--yinzhou
			var currentInput = addressInput.val();
			if (currentInput == addressbar._inputStatus.lastInput)
				return;
			addressbar._inputStatus.lastInput = currentInput;	

			addressbar.showEngineButton('address-go-button'); // 显示addressgo

			// modified by yinzhou
			// 延时100ms触发智能匹配，提高响应速度
			if (addressbar.timer != null) {
				clearTimeout(addressbar.timer);
			}
			addressbar.timer = setTimeout("addressbar.triggerInputChange('" + text + "'," + randomId.toString() + ")", 100);

		} else {
			$('#address').removeClass('dropdown');
			
			if (addressbar.timer != null) {
				clearTimeout(addressbar.timer);
			}
	
			if (addressbar._inputStatus.lastInput == '') {
				return;
			}
			addressbar._inputStatus.lastInput = '';

			addressbar.showEngineButton('address-placeholder');
			addressbar.showTextPlaceholder();			

			// modified by yinzhou
			// 隐藏下拉列表
			browser.skin.addressbar.adjustHeight(0); 
		}
						
	});

	addressInput.bind('keydown', function() {

		if(event.keyCode == 13) {
			addressbar._inputStatus.enter = true;
		}

		// 当按下esc键时，将地址设为当前页面的地址并隐藏下拉列表
		if(event.keyCode == 27) {
			var url = tabManager.getUrl(tabManager.getCurrentTab());
			addressbar.setAddress(url);
			addressbar.selectAllInput();
			browser.skin.addressbar.adjustHeight(0);
			if (url != '') {
				view.setEngine();
			}
			return;
		}

		addressbar.hideTextPlaceholder();

		if(addressbar.isListShown()) { 			
			// 上键
			if(event.keyCode == 38) {
				addressbar.selectUp();
				return false;
			}
			// 下键
			if(event.keyCode == 40) {
				addressbar.selectDown();
				return false;
			}
		} 
	});

	// 解决输入后每次匹配内容闪烁的问题
	addressInput.bind('keypress', function() {
		var addressInput = $('#address-input');
		var inputChar = String.fromCharCode(event.keyCode);

		var currentSelectedText = window.getSelection().toString();
		var currentInputText = addressInput.val();

		var tobeSelectedIndex = currentInputText.length - currentSelectedText.length + 1;

		// 如果输入的为选中的第一个字符，改变选中状态，不进行下面的处理
		if(currentSelectedText.indexOf(inputChar) == 0) {
			addressInput.get(0).setSelectionRange(tobeSelectedIndex, tobeSelectedIndex + currentSelectedText.length);
			
			//added by yinzhou
			//输入新的字符必须触发新的匹配，只是此时地址栏内容不需要刷新
			addressbar._inputStatus.needSetAddress = false;

			// modified by yinzhou
			// 延时100ms触发智能匹配，提高响应速度
			if (addressbar.timer != null) {
				clearTimeout(addressbar.timer);
			}
			var text = currentInputText.substring(0, tobeSelectedIndex);
			var inputId = utils.randomInt(4);
			addressbar.timer = setTimeout("addressbar.triggerInputChange('" + text + "'," + inputId.toString() + ")", 100);

			return false;
		}
	});
	
	addressInput.blur(function() {
		addressbar._isAddressbarActive = false;
		addressbar._isAddressinputFocus = false;
		
		if (!addressbar._cleared)
		{
			addressbar._selectionStart = addressInput.get(0).selectionStart;
			addressbar._selectionEnd = addressInput.get(0).selectionEnd;				
		}
		addressbar.cancelSelectedInput();
	});
};


addressbar.popup = function() {
	var addressInput = $('#address-input');

	// 触发地址栏下拉列表事件
	var addressListLeft = addressInput.offset().left;
	if (view._isMaximized) {
		addressListLeft -= 1;
	}
	var addressListTop = addressInput.offset().top + addressInput.outerHeight() + 1; // 与地址栏输入框下border重合
	var addressListWidth = $('#address-list-right').offset().left - $('#address-list-left').offset().left;

	browser.skin.addressbar.pop(addressListLeft, addressListTop, addressListWidth, 0); // 下拉条/triggerInputBegin时
};

addressbar.triggerInputChange = function(text, inputId) {
	if(!addressbar.isListShown()) { 
		addressbar.popup();
		browser.skin.addressbar.triggerInputBegin(); 
	} 

	browser.skin.addressbar.triggerInputChange(text, inputId); 	
};

addressbar.isFocus = function() {
	return addressbar._isAddressinputFocus;
};

addressbar.focus = function() {
	$('#address-input').focus();
};

addressbar.clearSelectionInfo = function() {
	addressbar._cleared = true;
	var url = $('#address-input').val();
	addressbar._selectionStart = url.length;
	addressbar._selectionEnd = url.length;
};

/*
 * 隐藏text placeholder
 */
addressbar.hideTextPlaceholder = function() {
	var textPlaceholder = $('#address-search-placeholder');
	
	if(textPlaceholder.is(":visible")) {
		var addressInput = $('#address-input');
		
		addressInput.width(addressInput.outerWidth() + textPlaceholder.width());
		textPlaceholder.hide();	
	}
};

/*
 * 显示text placeholder
 */
addressbar.showTextPlaceholder = function() {
	var textPlaceholder = $('#address-search-placeholder');
	
	if(textPlaceholder.is(":hidden")) {
		var addressInput = $('#address-input');

		addressInput.width(addressInput.outerWidth() - textPlaceholder.width());
		textPlaceholder.show();
	}
};


// 点击address list button时显示address list
addressbar.showAddresslist = function() {
	addressbar.popup();
	browser.skin.addressbar.triggerDroplistShowByClick(); // 另外一个接口
};

/**
 * 按上键，选择addresslist里的上一项
 */
addressbar.selectUp = function() {
	try {
		addressbar.getAddressListPage().executeScript("", "addressList.selectUp()");
	} catch(e) {
//		
	}
};

/**
 * 按下键，选择addresslist里的下一项
 */
addressbar.selectDown = function() {
	try {
		addressbar.getAddressListPage().executeScript("", "addressList.selectDown('select')");
	} catch(e) {
//		alert(e.message);		
	}
};

/**
 * open a link when address input done
 */ 
addressbar.openUrl = function(url, type, search) {
	url = url ? unescape(url) : $.trim($('#address-input').val());
	type = (typeof type != 'undefined') ? type : 1;
	search = search ? search : 0;

	if(url && (url != '')) {	
		addressbar.showEngineButton('engine-ie-button'); // 载入时显示ie标志
		
		browser.skin.addressbar.triggerInputAccept(url); // 下拉窗口消失
		
		browser.tabs.create(url, type, search); // call browser api
	}
};

/**
 * set url of addressbar
 */
addressbar.setAddress = function(url) {
	if(url == DEFAULT_SITE_URL) { // qb:home不显示
		url = '';
	}
	
	if(url != '') { // 切换tab时也需要判断是否显示text placeholder
		addressbar.hideTextPlaceholder();
	} else {
		addressbar.showEngineButton('address-placeholder');
		addressbar.showTextPlaceholder();
	}
	
	$('#address-input').val(url);
	addressbar._inputStatus.lastInput = url;

};

/**
 * 地址栏补全逻辑，地址栏下拉列表调用
 */
addressbar.fillAddress = function(url, type, firstUrl) {
	url = url ? unescape(url) : '';

	var addressInput = $('#address-input');

	if(url == 'qqbrowser:search') { // 判断是否选中下拉里的搜索项，置位
		addressbar._inputStatus.search = true;
		addressbar.setAddress(addressbar._inputStatus.text);
		return;
	} else {
		addressbar._inputStatus.search = false;
	}
	
	addressbar._inputStatus.firstUrl = firstUrl;

	// 拿到地址栏输入
	var text = ($.trim(addressInput.val())).replace(window.getSelection(), '');	

	if(type == 'select') { // type为select时，地址栏value为传进来的url，并选择全部
		addressbar.setAddress(url);
		addressInput.get(0).setSelectionRange(0, url.length);
	} else if(type == 'input') { // 回到输入状态
		addressbar.setAddress(addressbar._inputStatus.url);
		addressInput.get(0).setSelectionRange(addressbar._inputStatus.text.length, addressbar._inputStatus.url.length);	
		
	} else if(type == 'nomatch') {
		// 存储当前状态
		addressbar._inputStatus.text = text;
		addressbar._inputStatus.url = text;	
	} else { // 否则，补全并选择后面的部分
		
		if (addressbar._inputStatus.needSetAddress)	{
			var inputIndex = url.indexOf(text);
			if(inputIndex == 0) { // 当url以用户输入的text开头时，截取对应字符串，并设置高亮提示区
				addressbar.setAddress(url);
				addressInput.get(0).setSelectionRange(text.length, url.length);
			}
		}

		// 存储当前状态
		addressbar._inputStatus.text = text;
		addressbar._inputStatus.url = url;			
	}

	addressbar._inputStatus.needSetAddress = true;
};

/**
 * 选择全部文字
 */
addressbar.selectAllInput = function() {
	var url = $('#address-input').val();
	$('#address-input').get(0).setSelectionRange(0, url.length);
	addressbar._selectionStart = 0;
	addressbar._selectionEnd = url.length;
};

/**
 * 不选择文字
 */
addressbar.cancelSelectedInput = function() {
	var url = $('#address-input').val();
	$('#address-input').get(0).setSelectionRange(url.length, url.length);
};

/**
 * 删除选中的文字
 */
addressbar.deleteSelectedInput = function() {
    // TODO 解决闪烁的问题
    var url   = $('#address-input').val();
    var start = $('#address-input')[0].selectionStart;  // 选择范围的起始 index
    var end   = $('#address-input')[0].selectionEnd;    // 选择范围的终止 index

    // 通过把被删除文字左边的子字符串和右边的子字符串拼接起来形成新的 URL
    url = url.slice(0, start) + url.slice(end);

    // 让地址栏显示新的 URL
    $('#address-input').val(url);

    // 设置新的选择范围
    $('#address-input')[0].setSelectionRange(start, start);
};

/**
 * 设置地址栏引擎按钮
 */
addressbar.showEngineButton = function(showButtonId) {
	var engineIEId = 'engine-ie-button';
	var engineWebkitId = 'engine-webkit-button';
	var enginePlaceHolderId = 'address-placeholder';
	var addressGoId = 'address-go-button';
	
	// hide all buttons
	$('#' + engineIEId).hide();
	$('#' + engineWebkitId).hide();
	$('#' + addressGoId).hide();	
	$('#' + enginePlaceHolderId).hide();	
	
	$('#' + showButtonId).show();		
};

// 地址栏下拉是否显示
addressbar._isListShown = false;

addressbar.setIsListShown = function(isListShown) {
	addressbar._isListShown = isListShown;

	// 地址栏边框的样式需要根据地址栏下拉是否显示决定
	if(isListShown) {
		$('#address').addClass('dropdown');
	} else {
		$('#address').removeClass('dropdown');
	}
};

// 当前一个状态是true，后一个状态是false时（由点击地址栏下拉按钮触发），认为地址栏下拉是显示状态
addressbar.isListShown = function() {
	return addressbar._isListShown;
};

